
package compositePakage;

public class CompositeExample 
{

public static void main(String[] args) 
	{
    // creiamo 4 componenti "Leaf"
    Component nina = new Leaf("Nina");
    Component pinta = new Leaf("Pinta");
    Component s_maria = new Leaf("Santa Maria");
    Component c_colombo = new Leaf("Cristoforo Colombo");

    // un composite con 3 dei 4 leaf
    Component caravelle = new Composite("Caravelle");
    try 
    	{
    	caravelle.add(nina);
    	caravelle.add(pinta);
    	caravelle.add(s_maria);
    	}
    catch (LeafException e)
    	{
    	/* printStackTrace():
    	 * Prints this throwable and its backtrace to the standard error 
    	 * stream. This method prints a stack trace for this Throwable 
    	 * object on the error output stream that is the value of the field 
    	 * System.err. */
    	e.printStackTrace();
    	}

    // un composite composto da un altro composite e da un leaf
    Component spedizione = new Composite("Spedizione");
    try
    	{
    	spedizione.add(caravelle);
    	spedizione.add(c_colombo);
    	}
    catch (LeafException e)
    	{ e.printStackTrace(); }

    // prova di richiamo operation() su alcuni oggetti
    nina.printName();
    caravelle.printName();
    spedizione.printName();

    // errore: si prova a richiamare add() su un Leaf!!!

    try
    	{ c_colombo.add(caravelle); }
    catch (LeafException e)
    	{ e.printStackTrace(); }

	} // end main()
}
